<?php
// Security check
defined('ABSPATH') || die();

if(!class_exists('Redux')) return;

if( !class_exists('RTReduxFontPreloader') ):

$optimization_settings = array(
    'sections' => array(
        array(
            'title' => esc_html__( 'Speed Optimization', 'metro' ),
            'id'    => 'rt_speed_optimization',
            'icon'  => 'el el-shopping-cart',
            'subsections' => array(
                array(
                    'title'   => esc_html__( 'Fonts Preload', 'metro' ),
                    'id'      => 'rt_so_fonts_preload',
                    'subsection' => true,
                    'fields' => array(
                        array(
                            'id'       => 'rt_so_fonts_preload_csv',
                            'type'     => 'textarea',
                            'title'    => esc_html__( 'URL(s)', 'metro'), 
                            'placeholder' => 'https://font-css-url/..., &#13;https://font-css-url/...',
                            'default'  => '
                                http://localhost/wordpress/products/metro/wp-content/plugins/yith-woocommerce-wishlist/assets/css/font-awesome.css,
                                http://localhost/wordpress/products/metro/wp-content/plugins/elementor/assets/lib/font-awesome/css/all.min.css,
                                http://localhost/wordpress/products/metro/wp-content/plugins/elementor/assets/lib/font-awesome/css/v4-shims.min.css,
                                http://localhost/wordpress/products/metro/wp-content/plugins/elementor/assets/lib/font-awesome/css/font-awesome.min.css
                            ',
                        ),  

                    )
                ),
            )
        )
    )
);

class RTReduxFontPreloader{

    public $option, $settings;

    function __construct($option, $settings){
        
        $this->option = $option;
        $this->settings = $settings;

        $this->section();
        
        // add_filter( 'style_loader_tag', array(&$this, 'preload_style'), 10, 4 );
        add_filter( 'wp_head', array(&$this, 'preload_font'), 9);

    }

    function preload_font(){
        
        $urls = array_map('trim', explode(',', ( ClenixTheme::$options['rt_so_fonts_preload_csv'] ) ) );
    
        foreach($urls as $url)
            echo "<link rel='preload' href='{$url}' as='font' type='font/woff2' crossorigin />";

    }

    function section(){

        foreach($this->settings['sections'] as $section){

            $section_setting = array();

            foreach($section as $key => $value){

                if( $key == 'subsections' ) continue;

                $section_setting[$key] = $value;

            }

            Redux::setSection( $this->option, $section_setting );

            $this->add_subsection($section['subsections']);

        }

    }

    function add_subsection($subsections){

        foreach($subsections as $subsec){

            Redux::setSection($this->option, $subsec);

        }

    }

}

new RTReduxFontPreloader('clenix', $optimization_settings);

endif;