<?php

namespace WPForms\Integrations\DefaultContent;

use WPForms\Integrations\IntegrationInterface;

/**
 * Class DefaultContent.
 *
 * @since 1.7.2
 */
class DefaultContent implements IntegrationInterface {

	/**
	 * Indicate if current integration is allowed to load.
	 *
	 * @since 1.7.2
	 *
	 * @return bool
	 */
	public function allow_load() {

		global $pagenow;

		return get_option( 'fresh_site' ) && $pagenow === 'customize.php';
	}

	/**
	 * Load an integration.
	 *
	 * @since 1.7.2
	 */
	public function load() {

		add_filter( 'get_theme_starter_content', [ $this, 'modify_starter_content' ], 1000, 2 );
	}

	/**
	 * Append education text to Contact page content.
	 *
	 * @since 1.7.2
	 *
	 * @param array $content Array of starter content.
	 * @param array $config  Array of theme-specific starter content configuration.
	 *
	 * @return array
	 */
	public function modify_starter_content( $content, $config ) {

		if ( ! isset( $content['posts']['contact'] ) ) {
			return $content;
		}

		$content['posts']['contact']['post_content'] .= sprintf(
			"<!-- wp:paragraph -->\n<p>%s</p>\n<!-- /wp:paragraph -->",
			wp_kses(
				sprintf( /* translators: %s - forms overview page URL. */
					_x( 'Create your <a href="%s" target="_blank" rel="noopener noreferrer">contact form</a> with WPForms in minutes.', 'Theme starter content', 'wpforms-lite' ),
					esc_url( admin_url( 'admin.php?page=wpforms-overview' ) )
				),
				[
					'a' => [
						'href'   => [],
						'rel'    => [],
						'target' => [],
					],
				]
			)
		);

		return $content;
	}
}
